//
// Struttura dati per rappresentare un numero complesso
//

#include <math.h>

class complex {
private:
  float p_r;			// Parte Reale
  float p_i;			// Parte Immaginaria

public:
  // Metodi che realizzano l'interfaccia esterna
  complex(float r, float i);	// Costruttore 
  complex(float r);		// Costruttore che assegna solo la parte reale
  complex();			// Costruttore vuoto

  void set(float r, float i);	// "Assegnamento" di un nuovo valore
  float norma();		// Norma del numero complesso
  void stampa();		// Output su terminale

  friend complex operator+ (const complex z1, const complex z2);
  friend complex operator- (const complex z1, const complex z2);
  friend complex operator* (const complex z1, const complex z2);
};



// Restituisce la norma di un numero Complesso
// La funzione e` definita inline
inline float complex::norma()
{
  return(sqrt((p_r * p_r) + (p_i * p_i)));
}


