//
// Realizzazione del tipo di dato Numero Complesso
// Implementazione della Classe complex
//

#include <iostream.h>

#include "CompClass2.H"


// Costruttore di numero Complesso assegnando parte reale ed immaginaria
complex::complex(float r, float i)
{
  p_r = r;
  p_i = i;
}


// Costruttore di numero Complesso: inizializzazione della parte immaginaria
// di default a 0
complex::complex(float r)
{
  p_r = r;
  p_i = 0.0;
}

// Costruttore di numero Complesso: inizializzazione di default a 0
complex::complex()
{
  p_r = 0.0;
  p_i = 0.0;
}


// Assegna dei nuovi valori ad un numero Complesso
void complex::set(float r, float i)
{
  p_r = r;
  p_i = i;
}


// Funzione per la stampa di un numero Complesso
void complex::stampa()
{
  cout << p_r;

  if (p_i >= 0)
    cout << " + " << p_i;
  else
    cout << " - " << -p_i;

  cout << "i";
}


// Overload dell'operatore di addizione
complex operator+ (const complex z1, const complex z2)
{
  complex z3;
  z3.p_r =  z1.p_r + z2.p_r;
  z3.p_i =  z1.p_i + z2.p_i;

  return (z3);
}


// Overload dell'operatore di sottrazione
complex operator- (const complex z1, const complex z2)
{
  complex z3;
  z3.p_r =  z1.p_r - z2.p_r;
  z3.p_i =  z1.p_i - z2.p_i;

  return (z3);
}


// Overload dell'operatore di moltiplicazione
complex operator* (const complex z1, const complex z2)
{
  complex z3;
  z3.p_r =  z1.p_r * z2.p_r - z1.p_i * z2.p_i;
  z3.p_i =  z1.p_r * z2.p_i + z1.p_i * z2.p_r;

  return (z3);
}
